/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc;

import com.floragunn.searchguard.privileges.SpecialPrivilegesEvaluationContext;
import com.floragunn.searchguard.privileges.SpecialPrivilegesEvaluationContextProviderRegistry;
import com.floragunn.searchguard.user.User;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.threadpool.ThreadPool;

public class AuthInfoService {
    private final ThreadPool threadPool;
    private final SpecialPrivilegesEvaluationContextProviderRegistry specialPrivilegesEvaluationContextProviderRegistry;

    public AuthInfoService(ThreadPool threadPool, SpecialPrivilegesEvaluationContextProviderRegistry specialPrivilegesEvaluationContextProviderRegistry) {
        this.threadPool = threadPool;
        this.specialPrivilegesEvaluationContextProviderRegistry = specialPrivilegesEvaluationContextProviderRegistry;
    }

    public User getCurrentUser() {
        User user = this.peekCurrentUser();
        if (user == null) {
            throw new ElasticsearchSecurityException("No user information available", new Object[0]);
        }
        return user;
    }

    public User peekCurrentUser() {
        return (User)this.threadPool.getThreadContext().getTransient("_sg_user");
    }

    public TransportAddress getCurrentRemoteAddress() {
        return (TransportAddress)this.threadPool.getThreadContext().getTransient("_sg_remote_address");
    }

    public SpecialPrivilegesEvaluationContext getSpecialPrivilegesEvaluationContext() {
        return this.specialPrivilegesEvaluationContextProviderRegistry.provide(this.getCurrentUser(), this.threadPool.getThreadContext());
    }
}

